/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import java.util.HashMap;
import java.util.Map;

public class SimpleGraphMaker
extends BaseGraphMaker {
    private Map graphs = new HashMap();

    public SimpleGraphMaker(Reifier.Style style) {
        super(style);
    }

    public SimpleGraphMaker() {
        this(Reifier.Minimal);
    }

    public Graph createGraph(String string, boolean bl) {
        Graph graph = (Graph)this.graphs.get(string);
        if (graph == null) {
            GraphMem graphMem = new GraphMem(this.style);
            this.graphs.put(string, graphMem);
            return graphMem;
        }
        if (bl) {
            throw new AlreadyExistsException(string);
        }
        return graph;
    }

    public Graph openGraph(String string, boolean bl) {
        Graph graph = (Graph)this.graphs.get(string);
        if (graph == null) {
            if (bl) {
                throw new DoesNotExistException(string);
            }
            return this.createGraph(string, true);
        }
        return graph;
    }

    public void removeGraph(String string) {
        if (!this.graphs.containsKey(string)) {
            throw new DoesNotExistException(string);
        }
        this.graphs.remove(string);
    }

    public boolean hasGraph(String string) {
        return this.graphs.containsKey(string);
    }

    public void close() {
    }
}

