/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.graph.impl.ReifyingCaptureGraph;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.JenaAddDeniedException;
import com.hp.hpl.jena.shared.JenaDeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public abstract class GraphBase
implements Graph {
    private Reifier.Style style;
    protected GraphEventManager gem;
    private BulkUpdateHandler bud;
    private PrefixMapping pm = new PrefixMappingImpl();
    protected Reifier reifier = null;

    public GraphBase(Reifier.Style style) {
        this.style = style;
    }

    public GraphBase() {
        this(Reifier.Minimal);
    }

    public boolean dependsOn(Graph graph) {
        return this == graph;
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler(this);
    }

    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager(this);
        }
        return this.gem;
    }

    public void notifyAdd(Triple triple) {
        this.getEventManager().notifyAddTriple(triple);
    }

    public void notifyDelete(Triple triple) {
        this.getEventManager().notifyDeleteTriple(triple);
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bud == null) {
            this.bud = new SimpleBulkUpdateHandler(this);
        }
        return this.bud;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public PrefixMapping getPrefixMapping() {
        return this.pm;
    }

    public void add(Triple triple) {
        this.performAdd(triple);
        this.notifyAdd(triple);
    }

    public void performAdd(Triple triple) {
        throw new JenaAddDeniedException("GraphBase::performAdd");
    }

    public void delete(Triple triple) {
        this.performDelete(triple);
        this.notifyDelete(triple);
    }

    public void performDelete(Triple triple) {
        throw new JenaDeleteDeniedException("GraphBase::delete");
    }

    public abstract ExtendedIterator find(TripleMatch var1);

    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean contains(Node node, Node node2, Node node3) {
        return this.containsByFind(Triple.create(node, node2, node3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean containsByFind(Triple triple) {
        ExtendedIterator extendedIterator = this.find(triple);
        try {
            boolean bl = extendedIterator.hasNext();
            return bl;
        }
        finally {
            extendedIterator.close();
        }
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.find(Triple.createMatch(node, node2, node3));
    }

    public void close() {
    }

    public Reifier getReifier() {
        if (this.reifier == null) {
            this.reifier = new SimpleReifier(this, this.style.intercepts());
        }
        return this.reifier;
    }

    public int size() {
        throw new UnsupportedOperationException("GraphBase::size");
    }

    public int capabilities() {
        return 0;
    }

    public boolean isIsomorphicWith(Graph graph) {
        return graph != null && GraphMatcher.equals(this, graph);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        String string = "";
        ExtendedIterator extendedIterator = this.find(null, null, null);
        while (extendedIterator.hasNext()) {
            stringBuffer.append(string);
            string = "; ";
            stringBuffer.append(extendedIterator.next());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static Graph withReification(Graph graph) {
        return new ReifyingCaptureGraph(graph);
    }
}

