/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FileGraphMaker
extends BaseGraphMaker {
    private String root;
    private boolean deleteOnClose;
    private Map created = new HashMap();

    public FileGraphMaker(String string) {
        this(string, Reifier.Minimal);
    }

    public FileGraphMaker(String string, Reifier.Style style) {
        this(string, style, false);
    }

    public FileGraphMaker(String string, Reifier.Style style, boolean bl) {
        super(style);
        this.root = string;
        this.deleteOnClose = bl;
    }

    public Graph getGraph() {
        return FileGraph.create();
    }

    public Graph createGraph(String string, boolean bl) {
        File file = this.withRoot(string);
        Graph graph = (Graph)this.created.get(file);
        if (graph == null) {
            return this.remember(file, new FileGraph(file, true, bl, this.style));
        }
        if (bl) {
            throw new AlreadyExistsException(string);
        }
        return graph;
    }

    public Graph openGraph(String string, boolean bl) {
        File file = this.withRoot(string);
        return this.created.containsKey(file) ? (Graph)this.created.get(file) : this.remember(file, new FileGraph(file, false, bl, this.style));
    }

    private File withRoot(String string) {
        return new File(this.root, this.makeSafe(string));
    }

    private String makeSafe(String string) {
        return this.replaceBy(string, "_/:", "USC");
    }

    private String replaceBy(String string, String string2, String string3) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 10);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = string2.indexOf(c);
            stringBuffer.append(n2 < 0 ? c : string3.charAt(n2));
        }
        return stringBuffer.toString();
    }

    public void removeGraph(String string) {
        this.forget(this.withRoot(string)).delete();
    }

    private FileGraph remember(File file, FileGraph fileGraph) {
        this.created.put(file, fileGraph);
        return fileGraph;
    }

    private File forget(File file) {
        this.created.remove(file);
        return file;
    }

    public boolean hasGraph(String string) {
        File file = this.withRoot(string);
        return this.created.containsKey(file) || file.exists();
    }

    public void close() {
        if (this.deleteOnClose) {
            Iterator iterator = this.created.keySet().iterator();
            while (iterator.hasNext()) {
                ((File)iterator.next()).delete();
            }
        }
    }
}

