/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.CompositionBase;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Polyadic
extends CompositionBase {
    protected List m_subGraphs = new ArrayList();
    protected Graph m_baseGraph = null;

    public Polyadic() {
    }

    public Polyadic(Graph[] graphArray) {
        for (int i = 0; i < graphArray.length; ++i) {
            this.m_subGraphs.add(graphArray[i]);
        }
    }

    public Polyadic(Iterator iterator) {
        while (iterator.hasNext()) {
            this.m_subGraphs.add(iterator.next());
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
    }

    public int capabilities() {
        return 7;
    }

    public void close() {
        Iterator iterator = this.m_subGraphs.iterator();
        while (iterator.hasNext()) {
            ((Graph)iterator.next()).close();
        }
    }

    public boolean dependsOn(Graph graph) {
        return graph == this || this.m_subGraphs.contains(graph);
    }

    public void addGraph(Graph graph) {
        this.m_subGraphs.add(graph);
    }

    public void removeGraph(Graph graph) {
        this.m_subGraphs.remove(graph);
        if (this.m_baseGraph == graph) {
            this.m_baseGraph = null;
        }
    }

    public Graph getBaseGraph() {
        if (this.m_baseGraph == null) {
            return this.m_subGraphs.size() == 0 ? null : (Graph)this.m_subGraphs.get(0);
        }
        return this.m_baseGraph;
    }

    public void setBaseGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            throw new IllegalArgumentException("The updateable graph must be one of the graphs from the composition");
        }
        this.m_baseGraph = graph;
    }

    public List getSubGraphs() {
        ArrayList arrayList = new ArrayList(this.m_subGraphs);
        if (this.getBaseGraph() != null) {
            arrayList.remove(this.getBaseGraph());
        }
        return arrayList;
    }
}

