/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.StringTokenizer;

public final class Triple
implements TripleMatch {
    private final Node subj;
    private final Node pred;
    private final Node obj;

    public Triple(Node node, Node node2, Node node3) {
        this.subj = node;
        this.pred = node2;
        this.obj = node3;
    }

    public String toString() {
        return this.subj + " @" + this.pred + " " + this.obj;
    }

    public Node getSubject() {
        return this.subj;
    }

    public Node getPredicate() {
        return this.pred;
    }

    public Node getObject() {
        return this.obj;
    }

    public Node getMatchSubject() {
        return Triple.anyToNull(this.subj);
    }

    public Node getMatchPredicate() {
        return Triple.anyToNull(this.pred);
    }

    public Node getMatchObject() {
        return Triple.anyToNull(this.obj);
    }

    private static Node anyToNull(Node node) {
        return Node.ANY.equals(node) ? null : node;
    }

    private static Node nullToAny(Node node) {
        return node == null ? Node.ANY : node;
    }

    public Triple asTriple() {
        return this;
    }

    public boolean isConcrete() {
        return this.subj.isConcrete() && this.pred.isConcrete() && this.obj.isConcrete();
    }

    public boolean equals(Object object) {
        return object instanceof Triple && ((Triple)object).sameAs(this.subj, this.pred, this.obj);
    }

    private boolean sameAs(Node node, Node node2, Node node3) {
        return this.subj.equals(node) && this.pred.equals(node2) && this.obj.equals(node3);
    }

    public boolean matches(Triple triple) {
        return triple.matchedBy(this.subj, this.pred, this.obj);
    }

    public boolean matches(Node node, Node node2, Node node3) {
        return this.subj.matches(node) && this.pred.matches(node2) && this.obj.matches(node3);
    }

    private boolean matchedBy(Node node, Node node2, Node node3) {
        return node.matches(this.subj) && node2.matches(this.pred) && node3.matches(this.obj);
    }

    public boolean subjectMatches(Node node) {
        return this.subj.matches(node);
    }

    public boolean predicateMatches(Node node) {
        return this.pred.matches(node);
    }

    public boolean objectMatches(Node node) {
        return this.obj.matches(node);
    }

    public int hashCode() {
        return this.subj.hashCode() >> 1 ^ this.pred.hashCode() ^ this.obj.hashCode() << 1;
    }

    public static Triple create(Node node, Node node2, Node node3) {
        return new Triple(node, node2, node3);
    }

    public static Triple createMatch(Node node, Node node2, Node node3) {
        return Triple.create(Triple.nullToAny(node), Triple.nullToAny(node2), Triple.nullToAny(node3));
    }

    public static Triple create(String string) {
        return Triple.create(PrefixMapping.Standard, string);
    }

    public static Triple create(PrefixMapping prefixMapping, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Node node = Node.create(prefixMapping, stringTokenizer.nextToken());
        Node node2 = Node.create(prefixMapping, stringTokenizer.nextToken());
        Node node3 = Node.create(prefixMapping, stringTokenizer.nextToken());
        return new Triple(node, node2, node3);
    }
}

