/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.GetTriple;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;

public interface Reifier
extends GetTriple {
    public static final Node type = RDF.type.asNode();
    public static final Node subject = RDF.subject.asNode();
    public static final Node predicate = RDF.predicate.asNode();
    public static final Node object = RDF.object.asNode();
    public static final Node Statement = RDF.Statement.asNode();
    public static final Style Standard = new Style(true, false);
    public static final Style Convenient = new Style(true, true);
    public static final Style Minimal = new Style(false, false);

    public Graph getHiddenTriples();

    public Graph getParentGraph();

    public Node reifyAs(Node var1, Triple var2);

    public boolean hasTriple(Node var1);

    public boolean hasTriple(Triple var1);

    public ExtendedIterator allNodes();

    public void remove(Node var1, Triple var2);

    public void remove(Triple var1);

    public boolean handledAdd(Triple var1);

    public boolean handledRemove(Triple var1);

    public static class AlreadyReifiedException
    extends CannotReifyException {
        public AlreadyReifiedException(Node node) {
            super(node);
        }
    }

    public static class CannotReifyException
    extends JenaException {
        public CannotReifyException(Node node) {
            super(node.toString());
        }
    }

    public static class Style {
        private boolean intercept;
        private boolean conceal;

        Style(boolean bl, boolean bl2) {
            this.intercept = bl;
            this.conceal = bl2;
        }

        public boolean intercepts() {
            return this.intercept;
        }

        public boolean conceals() {
            return this.conceal;
        }
    }
}

