/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.GetTriple;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class Node {
    protected final Object label;
    static final int THRESHOLD = 1000;
    static final HashMap present = new HashMap(2000);
    static final Logger log = Logger.getLogger((Class)(class$com$hp$hpl$jena$graph$Node == null ? (class$com$hp$hpl$jena$graph$Node = Node.class$("com.hp.hpl.jena.graph.Node")) : class$com$hp$hpl$jena$graph$Node));
    public static final Node ANY = new Node_ANY();
    static final String RDFprefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final NodeMaker makeAnon = new NodeMaker(){

        Node construct(Object object) {
            return new Node_Blank(object);
        }
    };
    static final NodeMaker makeLiteral = new NodeMaker(){

        Node construct(Object object) {
            return new Node_Literal(object);
        }
    };
    static final NodeMaker makeURI = new NodeMaker(){

        Node construct(Object object) {
            return new Node_URI(object);
        }
    };
    static final NodeMaker makeVariable = new NodeMaker(){

        Node construct(Object object) {
            return new Node_Variable(object);
        }
    };
    private static boolean caching = true;
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$Node;

    public static Node create(String string) {
        return Node.create(PrefixMapping.Standard, string);
    }

    public static Node create(PrefixMapping prefixMapping, String string) {
        if (string.equals("")) {
            throw new JenaException("GraphTestBase::node does not accept an empty string as argument");
        }
        char c = string.charAt(0);
        if (c == '\'') {
            return Node.createLiteral(new LiteralLabel(string, "en-UK", false));
        }
        if (Character.isDigit(c)) {
            return Node.createLiteral(new LiteralLabel(string, "nn-NN", false));
        }
        if (c == '_') {
            return Node.createAnon(new AnonId(string));
        }
        if (string.equals("??")) {
            return ANY;
        }
        if (c == '?') {
            return Node.createVariable(string.substring(1));
        }
        if (c == '&') {
            return Node.createURI("q:" + string.substring(1));
        }
        int n = string.indexOf(58);
        if (n < 0) {
            return Node.createURI("eh:" + string);
        }
        return Node.createURI(prefixMapping.expandPrefix(string));
    }

    public static Node createAnon(AnonId anonId) {
        return Node.create(makeAnon, anonId);
    }

    public static Node createLiteral(LiteralLabel literalLabel) {
        return Node.create(makeLiteral, literalLabel);
    }

    public static Node createURI(String string) {
        return Node.create(makeURI, (Object)string);
    }

    public static Node createAnon() {
        return Node.createAnon(new AnonId());
    }

    public static Node createVariable(String string) {
        return Node.create(makeVariable, (Object)("?" + string));
    }

    public static Node createLiteral(String string, String string2, boolean bl) {
        if (string == null) {
            log.warn((Object)"null treated as empty string in createLiteral: this will become illegal.");
            string = "";
        }
        return Node.createLiteral(new LiteralLabel(string, string2, bl));
    }

    public static void nullLiteralsGenerateWarnings() {
    }

    public static Node createLiteral(String string, String string2, RDFDatatype rDFDatatype) throws DatatypeFormatException {
        return Node.createLiteral(new LiteralLabel(string, string2, rDFDatatype));
    }

    public abstract Object visitWith(NodeVisitor var1);

    public abstract boolean isConcrete();

    public boolean isLiteral() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public boolean isURI() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public AnonId getBlankNodeId() {
        throw new UnsupportedOperationException("this is not a blank node");
    }

    public LiteralLabel getLiteral() {
        throw new UnsupportedOperationException("this is not a literal node");
    }

    public String getURI() {
        throw new UnsupportedOperationException("this is not a URI node");
    }

    public Triple getTriple(GetTriple getTriple) {
        return getTriple.getTriple(this);
    }

    public String getName() {
        throw new UnsupportedOperationException("this (" + this.getClass() + ") is not a variable node");
    }

    Node(Object object) {
        this.label = object;
        if (present.size() > 1000) {
            present.clear();
        }
        if (caching) {
            present.put(object, this);
        }
    }

    public static void cache(boolean bl) {
        if (!bl) {
            present.clear();
        }
        caching = bl;
    }

    public static Node create(NodeMaker nodeMaker, Object object) {
        if (object == null) {
            throw new JenaException("Node.make: null label");
        }
        Node node = (Node)present.get(object);
        if (node == null) {
            node = nodeMaker.construct(object);
        }
        return node;
    }

    public abstract boolean equals(Object var1);

    public boolean sameValueAs(Object object) {
        return this.equals(object);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean matches(Node node) {
        return this.equals(node);
    }

    public String toString() {
        return this.label.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static abstract class NodeMaker {
        NodeMaker() {
        }

        abstract Node construct(Object var1);
    }
}

