/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.ResultSetTripleIterator;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.db.impl.SimpleCache;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchIterator;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class PSet_TripleStore_RDB
implements IPSet {
    public String m_ASTName = null;
    protected int MAX_LITERAL = 0;
    protected String ID_SQL_TYPE = null;
    protected boolean SKIP_DUPLICATE_CHECK = false;
    protected boolean SKIP_ALLOCATE_ID = false;
    protected boolean INSERT_BY_PROCEDURE = false;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected String EMPTY_LITERAL_MARKER = "EmptyLiteral";
    protected SQLCache m_sql = null;
    protected static final int DEFAULT_CACHE = 1000;
    protected ICache literalCache = new SimpleCache(1000);
    protected ICache resourceCache = new SimpleCache(1000);
    protected IRDBDriver m_driver = null;
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$db$impl$PSet_TripleStore_RDB == null ? (class$com$hp$hpl$jena$db$impl$PSet_TripleStore_RDB = PSet_TripleStore_RDB.class$("com.hp.hpl.jena.db.impl.PSet_TripleStore_RDB")) : class$com$hp$hpl$jena$db$impl$PSet_TripleStore_RDB));
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$PSet_TripleStore_RDB;

    public void setDriver(IRDBDriver iRDBDriver) throws RDFRDBException {
        this.m_driver = iRDBDriver;
    }

    public void setMaxLiteral(int n) {
        this.MAX_LITERAL = n;
    }

    public void setSQLType(String string) {
        this.ID_SQL_TYPE = string;
    }

    public void setSkipDuplicateCheck(boolean bl) {
        this.SKIP_DUPLICATE_CHECK = bl;
    }

    public void setSQLCache(SQLCache sQLCache) {
        this.m_sql = sQLCache;
    }

    public void setCachePreparedStatements(boolean bl) {
        this.CACHE_PREPARED_STATEMENTS = bl;
    }

    public void setASTname(String string) {
        this.m_ASTName = string;
    }

    protected String getASTname() {
        return this.m_ASTName;
    }

    public void close() {
    }

    public IRDBDriver driver() {
        return this.m_driver;
    }

    public void createASTable(String string) {
        try {
            this.m_sql.runSQLGroup("createStatementTable", this.getASTname(), String.valueOf(this.MAX_LITERAL));
        }
        catch (SQLException sQLException) {
            logger.warn((Object)"Problem formatting database", (Throwable)sQLException);
            throw new RDFRDBException("Failed to format database", sQLException);
        }
    }

    public void cleanDB() {
        try {
            this.m_sql.runSQLGroup("dropStatementTable", this.getASTname());
        }
        catch (SQLException sQLException) {
            logger.warn((Object)("Problem dropping table " + this.getASTname()), (Throwable)sQLException);
            throw new RDFRDBException("Failed to drop table ", sQLException);
        }
    }

    public IDBID allocateID(String string) throws RDFRDBException {
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery(string, new Object[0]);
            if (resultSetIterator.hasNext()) {
                return this.wrapDBID(resultSetIterator.getSingleton());
            }
            throw new RDFRDBException("Failed to allocate ID");
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql error", sQLException);
        }
    }

    public IDBID allocateLiteralID() throws RDFRDBException {
        return this.allocateID("allocateLiteralID");
    }

    protected boolean literalIsPlain(LiteralLabel literalLabel) {
        String string = literalLabel.getDatatypeURI();
        String string2 = literalLabel.language();
        String string3 = (String)literalLabel.getValue();
        return string3.length() < this.MAX_LITERAL && !PSet_TripleStore_RDB.literalHasLang(literalLabel) && !PSet_TripleStore_RDB.literalHasType(literalLabel);
    }

    protected static boolean literalHasLang(LiteralLabel literalLabel) {
        String string = literalLabel.language();
        return string != null && !string.equals("");
    }

    protected static boolean literalHasType(LiteralLabel literalLabel) {
        String string = literalLabel.getDatatypeURI();
        return string != null && !string.equals("");
    }

    public String toString() {
        return this.getClass().getPackage().getName();
    }

    public Node_Literal getLiteralFromCache(IDBID iDBID) {
        return (Node_Literal)this.literalCache.get(iDBID);
    }

    public IDBID wrapDBID(Object object) throws RDFRDBException {
        if (object instanceof Number) {
            return new DBIDInt(((Number)object).intValue());
        }
        if (object == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + object);
    }

    public int rowCount(String string) {
        int n = 0;
        try {
            String string2 = "getRowCount";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (SQLException sQLException) {
            logger.debug((Object)("tried to count rows in " + string));
            logger.debug((Object)"Caught exception: ", (Throwable)sQLException);
        }
        return n;
    }

    public Triple extractTripleFromRowData(String string, String string2, String string3) {
        Node node = string == null ? null : this.m_driver.RDBStringToNode(string);
        Node node2 = string2 == null ? null : this.m_driver.RDBStringToNode(string2);
        Node node3 = string3 == null ? null : this.m_driver.RDBStringToNode(string3);
        return new Triple(node, node2, node3);
    }

    public Object wrapFlag(boolean bl) {
        return bl ? new Short(1) : new Short(0);
    }

    public void deleteTriple(Triple triple, IDBID iDBID) {
        this.deleteTriple(triple, iDBID, false, new Hashtable());
    }

    public void deleteTriple(Triple triple, IDBID iDBID, boolean bl, Hashtable hashtable) {
        this.deleteTripleAR(triple, iDBID, null, bl, hashtable);
    }

    public void deleteTripleAR(Triple triple, IDBID iDBID, Node node, boolean bl, Hashtable hashtable) {
        boolean bl2 = node != null;
        String string = triple.getSubject() == Node.ANY ? null : this.m_driver.nodeToRDBString(triple.getSubject(), false);
        String string2 = triple.getPredicate() == Node.ANY ? null : this.m_driver.nodeToRDBString(triple.getPredicate(), false);
        String string3 = triple.getObject() == Node.ANY ? null : this.m_driver.nodeToRDBString(triple.getObject(), false);
        int n = ((DBIDInt)iDBID).getIntID();
        int n2 = 1;
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        PreparedStatement preparedStatement = null;
        String string4 = bl2 ? "deleteReified" : "deleteStatement";
        try {
            preparedStatement = this.getPreparedStatement(string4, this.getASTname(), bl, hashtable);
        }
        catch (SQLException sQLException) {
            logger.debug((Object)("SQLException caught " + sQLException.getErrorCode()), (Throwable)sQLException);
        }
        try {
            preparedStatement.setString(n2++, string);
            preparedStatement.setString(n2++, string2);
            preparedStatement.setString(n2++, string3);
            preparedStatement.setInt(n2++, n);
            if (bl2) {
                String string5 = this.m_driver.nodeToRDBString(node, false);
                preparedStatement.setString(n2++, string5);
            }
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"(in delete) SQLException caught ", (Throwable)sQLException);
        }
        try {
            if (bl) {
                preparedStatement.addBatch();
            } else {
                preparedStatement.executeUpdate();
                this.m_sql.returnPreparedSQLStatement(preparedStatement, string4);
            }
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Exception executing delete: ", (Throwable)sQLException);
        }
    }

    public void storeTriple(Triple triple, IDBID iDBID) {
        this.storeTriple(triple, iDBID, false, new Hashtable());
    }

    public PreparedStatement getPreparedStatement(String string, String string2, boolean bl, Hashtable hashtable) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string3 = SQLCache.concatOpName(string, string2);
        if (bl) {
            preparedStatement = (PreparedStatement)hashtable.get(string3);
            if (preparedStatement == null) {
                preparedStatement = this.m_sql.getPreparedSQLStatement(string, string2);
                hashtable.put(string3, preparedStatement);
            }
        } else {
            preparedStatement = this.m_sql.getPreparedSQLStatement(string, string2);
        }
        if (preparedStatement == null) {
            logger.error((Object)("prepared statement not found for " + string3));
        }
        return preparedStatement;
    }

    public void storeTriple(Triple triple, IDBID iDBID, boolean bl, Hashtable hashtable) {
        this.storeTripleAR(triple, iDBID, null, false, bl, hashtable);
    }

    public void storeTripleAR(Triple triple, IDBID iDBID, Node node, boolean bl, boolean bl2, Hashtable hashtable) {
        block19: {
            boolean bl3;
            boolean bl4 = bl3 = node != null;
            if (!this.SKIP_DUPLICATE_CHECK && !bl3 && this.statementTableContains(iDBID, triple)) {
                return;
            }
            String string = triple.getSubject() == Node.ANY ? null : this.m_driver.nodeToRDBString(triple.getSubject(), true);
            String string2 = triple.getPredicate() == Node.ANY ? null : this.m_driver.nodeToRDBString(triple.getPredicate(), true);
            String string3 = triple.getObject() == Node.ANY ? null : this.m_driver.nodeToRDBString(triple.getObject(), true);
            int n = ((DBIDInt)iDBID).getIntID();
            int n2 = 1;
            if (!(string != null && string2 != null && string3 != null || bl3)) {
                throw new JenaException("Attempt to assert triple with missing values");
            }
            PreparedStatement preparedStatement = null;
            String string4 = bl3 ? "insertReified" : "insertStatement";
            try {
                preparedStatement = this.getPreparedStatement(string4, this.getASTname(), bl2, hashtable);
            }
            catch (SQLException sQLException) {
                logger.debug((Object)("SQLException caught " + sQLException.getErrorCode()), (Throwable)sQLException);
            }
            try {
                if (string == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string);
                }
                if (string2 == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string2);
                }
                if (string3 == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string3);
                }
                preparedStatement.setInt(n2++, n);
                if (bl3) {
                    String string5 = this.m_driver.nodeToRDBString(node, true);
                    preparedStatement.setString(n2++, string5);
                    if (bl) {
                        preparedStatement.setString(n2++, "T");
                    } else {
                        preparedStatement.setString(n2++, " ");
                    }
                }
            }
            catch (SQLException sQLException) {
                logger.debug((Object)("SQLException caught " + sQLException.getErrorCode()), (Throwable)sQLException);
            }
            try {
                if (bl2) {
                    preparedStatement.addBatch();
                } else {
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 1 && this.m_driver.getDatabaseType().equalsIgnoreCase("oracle")) break block19;
                logger.error((Object)("SQLException caught during insert" + sQLException.getErrorCode()), (Throwable)sQLException);
                throw new JenaException(sQLException);
            }
        }
    }

    public void storeTripleList(List list, IDBID iDBID) {
        Hashtable hashtable = new Hashtable();
        try {
            Object object;
            Connection connection = this.m_sql.getConnection();
            boolean bl = connection.getAutoCommit();
            if (bl) {
                connection.setAutoCommit(false);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Triple triple = (Triple)iterator.next();
                this.storeTriple(triple, iDBID, true, hashtable);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                PreparedStatement preparedStatement = (PreparedStatement)hashtable.get(object);
                preparedStatement.executeBatch();
                this.m_sql.returnPreparedSQLStatement(preparedStatement, (String)object);
            }
            if (bl) {
                this.m_sql.getConnection().commit();
                connection.setAutoCommit(bl);
            }
            hashtable = new Hashtable();
            object = new ArrayList(list);
            list.removeAll((Collection<?>)object);
        }
        catch (BatchUpdateException batchUpdateException) {
            System.err.println("SQLException: " + batchUpdateException.getMessage());
            System.err.println("SQLState: " + batchUpdateException.getSQLState());
            System.err.println("Message: " + batchUpdateException.getMessage());
            System.err.println("Vendor: " + batchUpdateException.getErrorCode());
            System.err.print("Update counts: ");
            int[] nArray = batchUpdateException.getUpdateCounts();
            for (int i = 0; i < nArray.length; ++i) {
                System.err.print(nArray[i] + " ");
            }
        }
        catch (SQLException sQLException) {
            System.err.println("SQLException: " + sQLException.getMessage());
            System.err.println("SQLState: " + sQLException.getSQLState());
            System.err.println("Message: " + sQLException.getMessage());
            System.err.println("Vendor: " + sQLException.getErrorCode());
        }
    }

    public void deleteTripleList(List list, IDBID iDBID) {
        Hashtable hashtable = new Hashtable();
        try {
            Object object;
            Connection connection = this.m_sql.getConnection();
            boolean bl = connection.getAutoCommit();
            if (bl) {
                connection.setAutoCommit(false);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Triple triple = (Triple)iterator.next();
                this.deleteTriple(triple, iDBID, true, hashtable);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                PreparedStatement preparedStatement = (PreparedStatement)hashtable.get(object);
                preparedStatement.executeBatch();
            }
            if (bl) {
                this.m_sql.getConnection().commit();
                this.m_sql.getConnection().setAutoCommit(bl);
            }
            hashtable = new Hashtable();
            object = new ArrayList(list);
            list.removeAll((Collection<?>)object);
        }
        catch (BatchUpdateException batchUpdateException) {
            System.err.println("SQLException: " + batchUpdateException.getMessage());
            System.err.println("SQLState: " + batchUpdateException.getSQLState());
            System.err.println("Message: " + batchUpdateException.getMessage());
            System.err.println("Vendor: " + batchUpdateException.getErrorCode());
            System.err.print("Update counts: ");
            int[] nArray = batchUpdateException.getUpdateCounts();
            for (int i = 0; i < nArray.length; ++i) {
                System.err.print(nArray[i] + " ");
            }
        }
        catch (SQLException sQLException) {
            System.err.println("SQLException: " + sQLException.getMessage());
            System.err.println("SQLState: " + sQLException.getSQLState());
            System.err.println("Message: " + sQLException.getMessage());
            System.err.println("Vendor: " + sQLException.getErrorCode());
        }
    }

    public int tripleCount() {
        return this.rowCount(this.getASTname());
    }

    public boolean statementTableContains(IDBID iDBID, Triple triple) {
        ExtendedIterator extendedIterator = this.find(triple, iDBID);
        return extendedIterator.hasNext();
    }

    public ExtendedIterator find(TripleMatch tripleMatch, IDBID iDBID) {
        String string = this.getASTname();
        Node node = tripleMatch.getMatchSubject();
        Node node2 = tripleMatch.getMatchPredicate();
        Node node3 = tripleMatch.getMatchObject();
        int n = ((DBIDInt)iDBID).getIntID();
        boolean bl = false;
        ResultSetTripleIterator resultSetTripleIterator = new ResultSetTripleIterator(this, iDBID);
        PreparedStatement preparedStatement = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "selectStatement";
        int n2 = 1;
        if (node != null) {
            string2 = this.m_driver.nodeToRDBString(node, false);
            if (string2 == null) {
                bl = true;
            } else {
                string5 = string5 + "S";
            }
        }
        if (node2 != null) {
            string3 = this.m_driver.nodeToRDBString(node2, false);
            if (string3 == null) {
                bl = true;
            } else {
                string5 = string5 + "P";
            }
        }
        if (node3 != null) {
            string4 = this.m_driver.nodeToRDBString(node3, false);
            if (string4 == null) {
                bl = true;
            } else {
                string5 = string5 + "O";
            }
        }
        if (!bl) {
            try {
                preparedStatement = this.m_sql.getPreparedSQLStatement(string5, this.getASTname());
                if (string4 != null) {
                    preparedStatement.setString(n2++, string4);
                }
                if (string2 != null) {
                    preparedStatement.setString(n2++, string2);
                }
                if (string3 != null) {
                    preparedStatement.setString(n2++, string3);
                }
                preparedStatement.setInt(n2++, n);
                this.m_sql.executeSQL(preparedStatement, string5, resultSetTripleIterator);
            }
            catch (Exception exception) {
                bl = true;
                logger.debug((Object)("find encountered exception: args=" + n2 + " err: "), (Throwable)exception);
            }
        }
        if (bl) {
            resultSetTripleIterator.close();
        }
        return new TripleMatchIterator(tripleMatch.asTriple(), (Iterator)resultSetTripleIterator);
    }

    public void removeStatementsFromDB(IDBID iDBID) {
        String string = iDBID.getID().toString();
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("removeRowsFromTable", this.getASTname());
            preparedStatement.clearParameters();
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Problem removing statements from table: ", (Throwable)sQLException);
        }
    }

    public boolean tableExists(String string) {
        return this.m_driver.doesTableExist(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

