/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class Driver_MySQL
extends DriverRDB {
    public Driver_MySQL() {
        String string = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "MySQL";
        this.DRIVER_NAME = "com.mysql.jdbc.Driver";
        this.EMPTY_LITERAL_MARKER = "EmptyLiteral";
        this.ID_SQL_TYPE = "INTEGER";
        this.INSERT_BY_PROCEDURE = false;
        this.INDEX_KEY_LENGTH = 250;
        this.LONG_OBJECT_LENGTH = 250;
        this.HAS_XACTS = true;
        this.PRE_ALLOCATE_ID = false;
        this.SKIP_DUPLICATE_CHECK = false;
        this.EMPTY_LITERAL_MARKER = "EmptyLiteral";
        this.SQL_FILE = "etc/mysql.sql";
        this.DB_NAMES_TO_UPPER = false;
        this.m_psetClassName = string + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = string + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = string + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = string + ".SpecializedGraphReifier_RDB";
    }

    public void setConnection(IDBConnection iDBConnection) {
        this.m_dbcon = iDBConnection;
        try {
            Properties properties = SQLCache.loadSQLFile(this.DEFAULT_SQL_FILE, null, this.ID_SQL_TYPE);
            this.m_sql = new SQLCache(this.SQL_FILE, properties, iDBConnection, this.ID_SQL_TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            logger.error((Object)"Unable to set connection for Driver:", (Throwable)exception);
        }
    }

    public int graphIdAlloc(String string) {
        Object var2_2 = null;
        int n = 0;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("insertGraph");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            n = this.getInsertID("jena_graph");
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to get last inserted ID: " + sQLException);
        }
        return n;
    }

    public void graphIdDealloc(int n) {
        Object var2_2 = null;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("deleteGraph");
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to delete graph ID: " + sQLException);
        }
    }

    public int getInsertID(String string) {
        DBIDInt dBIDInt = null;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("getInsertID");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new RDFRDBException("No last insert ID");
            }
            dBIDInt = this.wrapDBID(resultSet.getObject(1));
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to get last inserted ID: " + sQLException);
        }
        return dBIDInt.getIntID();
    }

    protected void getTblParams(String[] stringArray) {
        String string;
        String string2;
        String string3 = Integer.toString(this.INDEX_KEY_LENGTH);
        if (this.INDEX_KEY_LENGTH > 250) {
            throw new RDFRDBException("Key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds MySQL maximum key length of 250.");
        }
        String string4 = string2 = this.HAS_XACTS ? "INNODB" : "MyISAM";
        if (this.HAS_XACTS) {
            string2 = "INNODB";
            if (this.LONG_OBJECT_LENGTH > 250) {
                throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds MySQL maximum VARCHAR length of 250.");
            }
            string = "VARCHAR(" + this.LONG_OBJECT_LENGTH + ") BINARY";
            this.STRINGS_TRIMMED = true;
            this.EOS = ":";
        } else {
            string2 = "MyISAM";
            string = this.LONG_OBJECT_LENGTH <= 250 ? "TINYBLOB" : "MEDIUMBLOB";
            this.STRINGS_TRIMMED = false;
            this.EOS = "";
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
    }

    protected String[] getDbInitTablesParams() {
        String[] stringArray = new String[3];
        this.getTblParams(stringArray);
        if (this.HAS_XACTS) {
            this.STRINGS_TRIMMED = true;
            this.EOS = ":";
        } else {
            this.STRINGS_TRIMMED = false;
            this.EOS = "";
        }
        this.EOS_LEN = this.EOS.length();
        return stringArray;
    }

    protected String[] getCreateTableParams(int n, boolean bl) {
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[4];
        this.getTblParams(stringArray);
        int n2 = this.getTableCount(n);
        String string = "jena_g" + Integer.toString(n) + "t" + Integer.toString(n2) + (bl ? "_reif" : "_stmt");
        stringArray2[0] = string = this.stringToDBname(string);
        stringArray2[1] = stringArray[0];
        stringArray2[2] = stringArray[1];
        stringArray2[3] = stringArray[2];
        return stringArray2;
    }
}

