/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropDatabase;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.DBPropPSet;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;

public abstract class DriverRDB
implements IRDBDriver {
    protected DBPropDatabase m_dbProps;
    protected String m_psetClassName;
    protected String m_psetReifierClassName;
    protected String m_lsetClassName;
    protected String m_lsetReifierClassName;
    protected String DRIVER_NAME;
    protected String DATABASE_TYPE;
    protected int INDEX_KEY_LENGTH;
    protected boolean HAS_XACTS;
    protected boolean STRINGS_TRIMMED;
    protected String EOS = "";
    protected char EOS_CHAR = (char)58;
    protected int EOS_LEN = 0;
    protected char QUOTE_CHAR = (char)34;
    protected boolean DB_NAMES_TO_UPPER = false;
    protected boolean URI_COMPRESS;
    protected int URI_COMPRESS_LENGTH;
    protected int LONG_OBJECT_LENGTH;
    protected String ID_SQL_TYPE;
    protected boolean SKIP_DUPLICATE_CHECK;
    protected boolean PRE_ALLOCATE_ID;
    protected String EMPTY_LITERAL_MARKER;
    protected String SQL_FILE;
    protected String DEFAULT_SQL_FILE = "etc/generic_generic.sql";
    protected boolean INSERT_BY_PROCEDURE;
    protected static final String TABLE_BASE_NAME = "jena_";
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected String LAYOUT_TYPE = "TripleStore";
    protected final String SYSTEM_STMT_TABLE = "jena_sys_stmt";
    protected final String LONG_LIT_TABLE = "jena_long_lit";
    protected final String LONG_URI_TABLE = "jena_long_uri";
    protected final String PREFIX_TABLE = "jena_prefix";
    protected final String GRAPH_TABLE = "jena_graph";
    protected final String DEFAULT_PROPS = "JENA_DEFAULT_GRAPH_PROPERTIES";
    protected final int DEFAULT_ID = 0;
    protected final String VERSION = "2.0alpha";
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB == null ? (class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB = DriverRDB.class$("com.hp.hpl.jena.db.impl.PSet_ReifStore_RDB")) : class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB));
    protected SQLCache m_sql = null;
    protected SpecializedGraph m_sysProperties = null;
    protected IDBConnection m_dbcon = null;
    private Boolean m_transactionsSupported;
    protected boolean inTransaction = false;
    protected static String RDBCodeURI = "U";
    protected static String RDBCodeBlank = "B";
    protected static String RDBCodeLiteral = "L";
    protected static String RDBCodePrefix = "P";
    protected static String RDBCodeValue = "v";
    protected static String RDBCodeRef = "r";
    protected static String RDBCodeDelim = ":";
    protected static char RDBCodeDelimChar = (char)58;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$PSet_ReifStore_RDB;
    static /* synthetic */ Class class$com$hp$hpl$jena$db$impl$IPSet;
    static /* synthetic */ Class class$java$lang$Integer;

    public IDBConnection getConnection() {
        return this.m_dbcon;
    }

    public SpecializedGraph getSystemSpecializedGraph() {
        if (this.m_sysProperties != null) {
            return this.m_sysProperties;
        }
        if (!this.isDBFormatOK()) {
            this.cleanDB();
            return this.formatAndConstructSystemSpecializedGraph();
        }
        this.getDbInitTablesParams();
        IPSet iPSet = this.createIPSetInstanceFromName(this.m_psetClassName, "jena_sys_stmt");
        this.m_sysProperties = this.createLSetInstanceFromName(this.m_lsetClassName, iPSet, 0);
        this.m_dbProps = new DBPropDatabase(this.m_sysProperties);
        return this.m_sysProperties;
    }

    protected SpecializedGraph formatAndConstructSystemSpecializedGraph() {
        Object object;
        try {
            object = this.getDbInitTablesParams();
            this.m_sql.runSQLGroup("initDBtables", (String[])object);
            this.m_sql.runSQLGroup("initDBgenerators");
        }
        catch (SQLException sQLException) {
            logger.warn((Object)"Problem formatting database", (Throwable)sQLException);
            throw new RDFRDBException("Failed to format database", sQLException);
        }
        object = this.createIPSetInstanceFromName(this.m_psetClassName, "jena_sys_stmt");
        this.m_sysProperties = this.createLSetInstanceFromName(this.m_lsetClassName, (IPSet)object, 0);
        this.m_dbProps = new DBPropDatabase(this.m_sysProperties, this.m_dbcon.getDatabaseType(), "2.0alpha", String.valueOf(this.LONG_OBJECT_LENGTH));
        DBPropGraph dBPropGraph = new DBPropGraph(this.m_sysProperties, "JENA_DEFAULT_GRAPH_PROPERTIES", "generic");
        dBPropGraph.addGraphId(0);
        return this.m_sysProperties;
    }

    abstract String[] getDbInitTablesParams();

    abstract String[] getCreateTableParams(int var1, boolean var2);

    public abstract int graphIdAlloc(String var1);

    public List createSpecializedGraphs(DBPropGraph dBPropGraph) {
        DBProp dBProp;
        String string = dBPropGraph.getName();
        String string2 = null;
        String string3 = null;
        int n = this.graphIdAlloc(string);
        dBPropGraph.addGraphId(n);
        boolean bl = false;
        String string4 = dBPropGraph.getDBSchema();
        if (string4 == null && string.equals("DEFAULT") || string4 != null && string4.equals("DEFAULT")) {
            bl = true;
            string4 = "JENA_DEFAULT_GRAPH_PROPERTIES";
        }
        if (string4 != null) {
            dBProp = DBPropGraph.findPropGraphByName(this.getSystemSpecializedGraph(), string4);
            if (dBProp != null) {
                string3 = dBProp.getReifTable();
                string2 = dBProp.getStmtTable();
            }
            if (!(string3 != null && string2 != null || bl)) {
                throw new RDFRDBException("Creating graph " + string + ": referenced schema not found: " + string4);
            }
        }
        if (string3 == null || string2 == null) {
            string3 = this.createTable(n, true);
            string2 = this.createTable(n, false);
            if (string3 == null || string2 == null) {
                throw new RDFRDBException("Creating graph " + string + ": cannot create tables");
            }
        }
        dBPropGraph.addStmtTable(string2);
        dBPropGraph.addReifTable(string3);
        dBProp = new DBPropPSet(this.m_sysProperties, this.m_psetReifierClassName, string3);
        DBPropLSet dBPropLSet = new DBPropLSet(this.m_sysProperties, "LSET_" + dBPropGraph.getName() + "_REIFIER", this.m_lsetReifierClassName);
        dBPropLSet.setPSet((DBPropPSet)dBProp);
        dBPropGraph.addLSet(dBPropLSet);
        DBPropPSet dBPropPSet = new DBPropPSet(this.m_sysProperties, this.m_psetClassName, string2);
        DBPropLSet dBPropLSet2 = new DBPropLSet(this.m_sysProperties, "LSET_" + dBPropGraph.getName(), this.m_lsetClassName);
        dBPropLSet2.setPSet(dBPropPSet);
        dBPropGraph.addLSet(dBPropLSet2);
        return this.recreateSpecializedGraphs(dBPropGraph);
    }

    public List recreateSpecializedGraphs(DBPropGraph dBPropGraph) {
        ArrayList<SpecializedGraph> arrayList = new ArrayList<SpecializedGraph>();
        int n = dBPropGraph.getGraphId();
        String[] stringArray = new String[]{this.m_lsetClassName, this.m_lsetReifierClassName};
        for (int i = 0; i < 2; ++i) {
            ExtendedIterator extendedIterator = dBPropGraph.getAllLSets();
            while (extendedIterator.hasNext()) {
                DBPropLSet dBPropLSet = (DBPropLSet)extendedIterator.next();
                if (dBPropLSet.getType().equals(stringArray[i])) continue;
                DBPropPSet dBPropPSet = dBPropLSet.getPset();
                IPSet iPSet = this.createIPSetInstanceFromName(dBPropPSet.getType(), dBPropPSet.getTable());
                arrayList.add(this.createLSetInstanceFromName(dBPropLSet.getType(), iPSet, n));
            }
        }
        return arrayList;
    }

    private IPSet createIPSetInstanceFromName(String string, String string2) {
        IPSet iPSet = null;
        try {
            iPSet = (IPSet)Class.forName(string).newInstance();
            iPSet.setDriver(this);
            iPSet.setMaxLiteral(this.LONG_OBJECT_LENGTH);
            iPSet.setSQLType(this.ID_SQL_TYPE);
            iPSet.setSkipDuplicateCheck(this.SKIP_DUPLICATE_CHECK);
            iPSet.setSQLCache(this.m_sql);
            iPSet.setCachePreparedStatements(this.CACHE_PREPARED_STATEMENTS);
            iPSet.setASTname(string2);
        }
        catch (Exception exception) {
            logger.warn((Object)"Unable to create IPSet instance ", (Throwable)exception);
        }
        return iPSet;
    }

    private SpecializedGraph createLSetInstanceFromName(String string, IPSet iPSet, int n) {
        SpecializedGraph specializedGraph = null;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{class$com$hp$hpl$jena$db$impl$IPSet == null ? (class$com$hp$hpl$jena$db$impl$IPSet = DriverRDB.class$("com.hp.hpl.jena.db.impl.IPSet")) : class$com$hp$hpl$jena$db$impl$IPSet, class$java$lang$Integer == null ? (class$java$lang$Integer = DriverRDB.class$("java.lang.Integer")) : class$java$lang$Integer};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{iPSet, new Integer(n)};
            specializedGraph = (SpecializedGraph)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to create instance of SpecializedGraph ", (Throwable)exception);
        }
        return specializedGraph;
    }

    public void removeSpecializedGraphs(DBPropGraph dBPropGraph, List list) {
        Object object;
        int n = dBPropGraph.getGraphId();
        ExtendedIterator extendedIterator = list.iterator();
        while (extendedIterator.hasNext()) {
            object = (SpecializedGraph)extendedIterator.next();
            this.removeSpecializedGraph((SpecializedGraph)object);
        }
        object = dBPropGraph.getStmtTable();
        String string = dBPropGraph.getReifTable();
        this.m_dbProps.removeGraph(dBPropGraph);
        if (n != 0) {
            boolean bl = false;
            boolean bl2 = false;
            extendedIterator = this.m_dbProps.getAllGraphs();
            while (extendedIterator.hasNext()) {
                DBPropGraph dBPropGraph2 = (DBPropGraph)extendedIterator.next();
                if (dBPropGraph2.getStmtTable().equals(object)) {
                    bl = true;
                }
                if (!dBPropGraph2.getReifTable().equals(string)) continue;
                bl2 = true;
            }
            if (!bl) {
                this.deleteTable((String)object);
            }
            if (!bl2) {
                this.deleteTable(string);
            }
            this.graphIdDealloc(n);
        }
    }

    private void removeSpecializedGraph(SpecializedGraph specializedGraph) {
        specializedGraph.clear();
    }

    public void setDatabaseProperties(Graph graph) {
        SpecializedGraph specializedGraph = this.getSystemSpecializedGraph();
        specializedGraph.clear();
        SpecializedGraph.CompletionFlag completionFlag = new SpecializedGraph.CompletionFlag();
        specializedGraph.add(graph, completionFlag);
    }

    public DBPropGraph getDefaultModelProperties() {
        SpecializedGraph specializedGraph = this.getSystemSpecializedGraph();
        DBPropGraph dBPropGraph = DBPropGraph.findPropGraphByName(specializedGraph, "JENA_DEFAULT_GRAPH_PROPERTIES");
        if (dBPropGraph == null) {
            logger.error((Object)"No default Model Properties found");
        }
        return dBPropGraph;
    }

    public boolean isDBFormatOK() {
        boolean bl = false;
        try {
            DatabaseMetaData databaseMetaData = this.m_dbcon.getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            String string = this.stringToDBname("jena%");
            ResultSet resultSet = databaseMetaData.getTables(null, null, string, stringArray);
            bl = resultSet.next();
            resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public String stringToDBname(String string) {
        String string2 = this.DB_NAMES_TO_UPPER ? string.toUpperCase() : string;
        return string2;
    }

    public void cleanDB() {
        try {
            DatabaseMetaData databaseMetaData = this.m_dbcon.getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            String string = this.stringToDBname("jena%");
            ResultSet resultSet = databaseMetaData.getTables(null, null, string, stringArray);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.m_sql.runSQLGroup("dropTable", (String)iterator.next());
            }
            if (this.PRE_ALLOCATE_ID) {
                this.clearSequences();
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", sQLException);
        }
    }

    public void clearSequences() {
    }

    public void removeSequence(String string) {
        if (this.sequenceExists(string)) {
            try {
                this.m_sql.runSQLGroup("DropSequence", string);
            }
            catch (Exception exception) {
                logger.warn((Object)("Unable to drop sequence " + string), (Throwable)exception);
            }
        }
    }

    public boolean sequenceExists(String string) {
        Object[] objectArray = new Object[]{string};
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            String string2 = "SelectSequenceName";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (Exception exception) {
            logger.error((Object)("Unable to select sequence " + string), (Throwable)exception);
        }
        return bl;
    }

    public List getSequences() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        Object[] objectArray = new Object[]{};
        Object var3_3 = null;
        try {
            String string = "SelectJenaSequences";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string);
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to select Jena sequences: ", (Throwable)exception);
        }
        return arrayList;
    }

    public void formatDB() throws RDFRDBException {
    }

    public String createTable(int n, boolean bl) {
        String[] stringArray;
        String string = bl ? "createReifStatementTable" : "createStatementTable";
        int n2 = 0;
        while (true) {
            stringArray = this.getCreateTableParams(n, bl);
            try {
                this.m_sql.runSQLGroup(string, stringArray);
            }
            catch (SQLException sQLException) {
                if (++n2 <= 5) continue;
                logger.warn((Object)"Problem creating table", (Throwable)sQLException);
                throw new RDFRDBException("Failed to create table: " + stringArray[0], sQLException);
            }
            break;
        }
        return stringArray[0];
    }

    public void deleteTable(String string) {
        String string2 = "dropTable";
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            preparedStatement.executeUpdate();
            return;
        }
        catch (Exception exception) {
            throw new RDFRDBException("Failed to delete table ", exception);
        }
    }

    private void notSupported(String string) {
        throw new UnsupportedOperationException(string);
    }

    public synchronized void abort() throws RDFRDBException {
        if (this.transactionsSupported()) {
            try {
                if (this.inTransaction) {
                    Connection connection = this.m_sql.getConnection();
                    connection.rollback();
                    connection.commit();
                    connection.setAutoCommit(true);
                    this.inTransaction = false;
                }
            }
            catch (SQLException sQLException) {
                throw new JenaException("Transaction support failed: ", sQLException);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void begin() throws RDFRDBException {
        if (this.transactionsSupported()) {
            try {
                if (this.inTransaction) return;
                Connection connection = this.m_sql.getConnection();
                connection.setTransactionIsolation(2);
                connection.setAutoCommit(false);
                this.inTransaction = true;
                return;
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Transaction support failed: ", sQLException);
            }
        } else {
            this.notSupported("begin transaction");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws RDFRDBException {
        if (this.transactionsSupported()) {
            try {
                if (!this.inTransaction) return;
                Connection connection = this.m_sql.getConnection();
                connection.commit();
                connection.setAutoCommit(true);
                this.inTransaction = false;
                return;
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Transaction support failed: ", sQLException);
            }
        } else {
            this.notSupported("commit transaction");
        }
    }

    public String getDatabaseType() {
        return this.DATABASE_TYPE;
    }

    public boolean transactionsSupported() {
        if (this.m_transactionsSupported != null) {
            return this.m_transactionsSupported;
        }
        if (this.m_dbcon != null) {
            try {
                Connection connection = this.m_sql.getConnection();
                if (connection != null) {
                    this.m_transactionsSupported = new Boolean(connection.getMetaData().supportsMultipleTransactions());
                    return this.m_transactionsSupported;
                }
            }
            catch (SQLException sQLException) {
                logger.error((Object)"SQL Exception caught ", (Throwable)sQLException);
            }
        }
        return false;
    }

    public void close() throws RDFRDBException {
    }

    public boolean supportsMultipleModels() {
        return true;
    }

    public boolean supportsJenaReification() {
        return false;
    }

    public String nodeToRDBString(Node node, boolean bl) throws RDFRDBException {
        String string = null;
        if (node.isURI()) {
            String string2;
            String string3;
            String string4 = new String(((Node_URI)node).getURI());
            if (string4.startsWith(RDBCodeURI)) {
                throw new RDFRDBException("URI Node looks like a blank node: " + string4);
            }
            int n = 0;
            boolean bl2 = this.URI_COMPRESS ? (n = Util.splitNamespace(string4)) == string4.length() || n <= this.URI_COMPRESS_LENGTH : true;
            if (bl2) {
                string3 = RDBCodeDelim + RDBCodeDelim;
                string2 = string4;
            } else {
                DBIDInt dBIDInt = this.URItoPrefix(string4, n, bl);
                if (dBIDInt == null) {
                    return string;
                }
                string3 = RDBCodeDelim + dBIDInt.getIntID() + RDBCodeDelim;
                string2 = string4.substring(n);
            }
            int n2 = RDBCodeURI.length() + 1 + string3.length() + this.EOS_LEN;
            boolean bl3 = this.objectIsLong(n2, string2);
            if (bl3) {
                DBIDInt dBIDInt = this.getURIID(string2, bl);
                if (dBIDInt == null) {
                    return string;
                }
                int n4 = dBIDInt.getIntID();
                string = new String(RDBCodeLiteral + RDBCodeRef + RDBCodeDelim + n4);
            } else {
                string = RDBCodeURI + RDBCodeValue + string3 + string2 + this.EOS;
            }
        } else if (node.isLiteral()) {
            Node_Literal node_Literal = (Node_Literal)node;
            LiteralLabel literalLabel = node_Literal.getLiteral();
            String string5 = literalLabel.getLexicalForm();
            String string6 = literalLabel.language();
            String string7 = literalLabel.getDatatypeURI();
            String string8 = this.litLangTypeToRDBString(string6, string7);
            int n = RDBCodeLiteral.length() + 2 + string8.length() + this.EOS_LEN;
            boolean bl4 = this.objectIsLong(n, string5);
            if (bl4) {
                DBIDInt dBIDInt = this.getLiteralID(node_Literal, bl);
                if (dBIDInt == null) {
                    return string;
                }
                int n5 = dBIDInt.getIntID();
                string = new String(RDBCodeLiteral + RDBCodeRef + RDBCodeDelim + n5);
            } else {
                string = new String(RDBCodeLiteral + RDBCodeValue + RDBCodeDelim + string8 + string5 + this.EOS);
            }
        } else if (node.isBlank()) {
            string = new String(RDBCodeBlank + RDBCodeValue + RDBCodeDelim + RDBCodeDelim + node.getBlankNodeId().toString() + this.EOS);
        } else {
            throw new RDFRDBException("Expected Concrete Node, got " + node.toString());
        }
        return string;
    }

    public Node RDBStringToNode(String string) throws RDFRDBException {
        Node node = null;
        int n = string.length();
        if (n < 3) {
            throw new RDFRDBException("Bad RDBString Header: " + string);
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        if (!string3.equals(RDBCodeRef) && !string3.equals(RDBCodeValue) || string.charAt(2) != RDBCodeDelimChar || n < 4) {
            throw new RDFRDBException("Bad RDBString Header: " + string);
        }
        int n2 = 3;
        if (string2.equals(RDBCodeURI)) {
            ParseInt parseInt = new ParseInt(n2);
            String string4 = "";
            this.RDBStringParseInt(string, parseInt, false);
            if (parseInt.val != null) {
                if (!this.URI_COMPRESS) {
                    throw new RDFRDBException("Bad URI: Prefix Compression Disabled: " + string);
                }
                string4 = this.IDtoPrefix(parseInt.val);
                if (string4 == null) {
                    throw new RDFRDBException("Bad URI Prefix: " + string);
                }
            }
            n2 = parseInt.pos + 1;
            String string5 = string.substring(n2, n - this.EOS_LEN);
            if (string3.equals(RDBCodeRef) && (string5 = this.IDtoURI(string5)) == null) {
                throw new RDFRDBException("Bad URI: " + string);
            }
            node = Node.createURI(string4 + string5);
        } else if (string2.equals(RDBCodeLiteral)) {
            LiteralLabel literalLabel;
            ParseInt parseInt = new ParseInt(n2);
            String string6 = null;
            if (string3.equals(RDBCodeRef)) {
                this.RDBStringParseInt(string, parseInt, true);
                if (parseInt.val != null) {
                    string6 = this.IDtoLiteral(parseInt.val);
                }
                if (string6 == null) {
                    throw new RDFRDBException("Bad Literal Reference: " + string);
                }
            } else {
                string6 = string.substring(n2, n - this.EOS_LEN);
            }
            n = string6.length();
            int n4 = 0;
            int n5 = 0;
            parseInt.pos = 0;
            this.RDBStringParseInt(string6, parseInt, false);
            n4 = parseInt.val == null ? 0 : parseInt.val;
            ++parseInt.pos;
            this.RDBStringParseInt(string6, parseInt, false);
            n5 = parseInt.val == null ? 0 : parseInt.val;
            n2 = parseInt.pos + 1;
            if (n2 + n4 + n5 > n) {
                throw new RDFRDBException("Malformed Literal: " + string6);
            }
            String string7 = string6.substring(n2, n2 + n4);
            String string8 = string6.substring(n2 += n4, n2 + n5);
            String string9 = string6.substring(n2 += n5);
            if (string8 == null || string8.equals("")) {
                literalLabel = new LiteralLabel(string9, string7 == null ? "" : string7);
            } else {
                RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string8);
                literalLabel = new LiteralLabel(string9, string7 == null ? "" : string7, rDFDatatype);
            }
            node = Node.createLiteral(literalLabel);
        } else if (string2.equals(RDBCodeBlank)) {
            String string10 = string.substring(4, n - this.EOS_LEN);
            node = Node.createAnon(new AnonId(string10));
        } else {
            throw new RDFRDBException("Invalid RDBString Prefix, " + string);
        }
        return node;
    }

    protected void RDBStringParseInt(String string, ParseInt parseInt, boolean bl) {
        int n;
        int n2 = n = bl ? string.length() : string.indexOf(RDBCodeDelimChar, parseInt.pos);
        if (n < 0) {
            throw new RDFRDBException("Bad RDB String: " + string);
        }
        String string2 = string.substring(parseInt.pos, n);
        parseInt.pos = n;
        if (string2.equals("")) {
            parseInt.val = null;
        } else {
            try {
                parseInt.val = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RDFRDBException("Bad RDB String: " + string);
            }
        }
    }

    DBIDInt URItoPrefix(String string, int n, boolean bl) {
        RDBLongObject rDBLongObject = this.PrefixToLongObject(string, n);
        return this.getLongObjectID(rDBLongObject, "jena_prefix", bl);
    }

    protected RDBLongObject PrefixToLongObject(String string, int n) {
        RDBLongObject rDBLongObject = new RDBLongObject();
        rDBLongObject.head = RDBCodePrefix + RDBCodeValue + RDBCodeDelim;
        int n2 = rDBLongObject.head.length();
        int n4 = this.INDEX_KEY_LENGTH - (n2 + this.EOS_LEN);
        if (n > n4) {
            rDBLongObject.head = rDBLongObject.head + string.substring(0, n4) + this.EOS;
            rDBLongObject.tail = string.substring(n4);
            rDBLongObject.hash = this.stringToHash(rDBLongObject.tail);
        } else {
            rDBLongObject.head = rDBLongObject.head + string;
            rDBLongObject.tail = "";
        }
        rDBLongObject.head = rDBLongObject.head + this.EOS;
        return rDBLongObject;
    }

    public String litLangTypeToRDBString(String string, String string2) throws RDFRDBException {
        String string3 = RDBCodeDelim;
        string3 = (string == null ? "" : Integer.toString(string.length())) + RDBCodeDelim;
        string3 = string3 + (string2 == null ? "" : Integer.toString(string2.length())) + RDBCodeDelim;
        string3 = string3 + (string == null ? "" : string) + (string2 == null ? "" : string2);
        return string3;
    }

    protected boolean objectIsLong(int n, String string) {
        return n + string.length() > this.LONG_OBJECT_LENGTH;
    }

    protected RDBLongObject literalToLongObject(Node_Literal node_Literal) {
        RDBLongObject rDBLongObject = new RDBLongObject();
        LiteralLabel literalLabel = node_Literal.getLiteral();
        String string = literalLabel.language();
        String string2 = literalLabel.getDatatypeURI();
        String string3 = literalLabel.getLexicalForm();
        String string4 = this.litLangTypeToRDBString(string, string2);
        rDBLongObject.head = RDBCodeLiteral + RDBCodeValue + RDBCodeDelim + string4;
        int n = rDBLongObject.head.length();
        int n2 = this.INDEX_KEY_LENGTH - (n + this.EOS_LEN);
        if (string3.length() > n2) {
            rDBLongObject.head = rDBLongObject.head + string3.substring(0, n2);
            rDBLongObject.tail = string3.substring(n2);
            rDBLongObject.hash = this.stringToHash(rDBLongObject.tail);
        } else {
            rDBLongObject.head = rDBLongObject.head + string3;
            rDBLongObject.tail = "";
        }
        rDBLongObject.head = rDBLongObject.head + this.EOS;
        return rDBLongObject;
    }

    protected long stringToHash(String string) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        return cRC32.getValue();
    }

    public DBIDInt getURIID(String string, boolean bl) throws RDFRDBException {
        RDBLongObject rDBLongObject = this.URIToLongObject(string);
        return this.getLongObjectID(rDBLongObject, "jena_long_uri", bl);
    }

    protected RDBLongObject URIToLongObject(String string) {
        RDBLongObject rDBLongObject = new RDBLongObject();
        rDBLongObject.head = RDBCodeURI + RDBCodeValue + RDBCodeDelim;
        int n = rDBLongObject.head.length();
        int n2 = this.INDEX_KEY_LENGTH - (n + this.EOS_LEN);
        if (string.length() > n2) {
            rDBLongObject.head = rDBLongObject.head + string.substring(0, n2) + this.EOS;
            rDBLongObject.tail = string.substring(n2);
            rDBLongObject.hash = this.stringToHash(rDBLongObject.tail);
        } else {
            rDBLongObject.head = rDBLongObject.head + string;
            rDBLongObject.tail = "";
        }
        rDBLongObject.head = rDBLongObject.head + this.EOS;
        return rDBLongObject;
    }

    public DBIDInt getLiteralID(Node_Literal node_Literal, boolean bl) throws RDFRDBException {
        RDBLongObject rDBLongObject = this.literalToLongObject(node_Literal);
        return this.getLongObjectID(rDBLongObject, "jena_long_lit", bl);
    }

    public DBIDInt getLongObjectID(RDBLongObject rDBLongObject, String string, boolean bl) throws RDFRDBException {
        try {
            String string2 = "getLongObjectID";
            if (rDBLongObject.tail.length() > 0) {
                string2 = string2 + "withChkSum";
            }
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            preparedStatement.setString(1, rDBLongObject.head);
            if (rDBLongObject.tail.length() > 0) {
                preparedStatement.setLong(2, rDBLongObject.hash);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            DBIDInt dBIDInt = null;
            if (resultSet.next()) {
                dBIDInt = this.wrapDBID(resultSet.getObject(1));
            } else if (bl) {
                dBIDInt = this.addRDBLongObject(rDBLongObject, string);
            }
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
            return dBIDInt;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", sQLException);
        }
    }

    public DBIDInt addRDBLongObject(RDBLongObject rDBLongObject, String string) throws RDFRDBException {
        try {
            int n = 1;
            String string2 = "insertLongObject";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            int n2 = 0;
            if (this.PRE_ALLOCATE_ID) {
                n2 = this.getInsertID(string);
                preparedStatement.setInt(n++, n2);
            }
            preparedStatement.setString(n++, rDBLongObject.head);
            if (rDBLongObject.tail.length() > 0) {
                preparedStatement.setLong(n++, rDBLongObject.hash);
                preparedStatement.setString(n++, rDBLongObject.tail);
            } else {
                preparedStatement.setNull(n++, -5);
                preparedStatement.setNull(n++, 12);
            }
            preparedStatement.executeUpdate();
            if (!this.PRE_ALLOCATE_ID) {
                n2 = this.getInsertID(string);
            }
            return this.wrapDBID(new Integer(n2));
        }
        catch (Exception exception) {
            System.out.println("Problem on long object (l=" + rDBLongObject.head + ") " + exception);
            throw new RDFRDBException("Failed to add long object ", exception);
        }
    }

    protected String IDtoPrefix(int n) {
        return this.IDtoString(n, "jena_prefix", RDBCodePrefix);
    }

    protected String IDtoURI(String string) {
        return this.IDtoString(string, "jena_long_uri", RDBCodeURI);
    }

    protected String IDtoLiteral(int n) {
        return this.IDtoString(n, "jena_long_lit", RDBCodeLiteral);
    }

    protected String IDtoString(String string, String string2, String string3) {
        int n;
        Object var5_4 = null;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RDFRDBException("Invalid Object ID: " + string);
        }
        return this.IDtoString(n, string2, string3);
    }

    protected String IDtoString(int n, String string, String string2) {
        String string3 = null;
        RDBLongObject rDBLongObject = this.IDtoLongObject(n, string);
        if (rDBLongObject == null) {
            throw new RDFRDBException("Invalid Object ID: " + n);
        }
        if (!rDBLongObject.head.substring(0, 3).equals(string2 + RDBCodeValue + RDBCodeDelim)) {
            throw new RDFRDBException("Malformed URI in Database: " + rDBLongObject.head);
        }
        string3 = rDBLongObject.head.substring(3, rDBLongObject.head.length() - this.EOS_LEN);
        string3 = string3 + rDBLongObject.tail;
        return string3;
    }

    protected RDBLongObject IDtoLongObject(int n, String string) {
        RDBLongObject rDBLongObject = null;
        try {
            String string2 = "getLongObject";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                rDBLongObject = new RDBLongObject();
                rDBLongObject.head = resultSet.getString(1);
                rDBLongObject.tail = resultSet.getString(2);
            }
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", sQLException);
        }
        return rDBLongObject;
    }

    protected RDBLongObject IDtoLongObject(String string, String string2) {
        int n;
        Object var3_3 = null;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RDFRDBException("Invalid Object ID: " + string);
        }
        return this.IDtoLongObject(n, string2);
    }

    public DBIDInt wrapDBID(Object object) throws RDFRDBException {
        if (object instanceof Number) {
            return new DBIDInt(((Number)object).intValue());
        }
        if (object == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + object);
    }

    public String genSQLReifQualStmt() {
        return "stmt = ?";
    }

    public String genSQLReifQualAnyObj(boolean bl) {
        return "( subj = ? OR prop = ? OR obj = ?" + (bl ? " OR hasType = " + this.QUOTE_CHAR + "T" + this.QUOTE_CHAR + " )" : " )");
    }

    public String genSQLReifQualObj(char c, boolean bl) {
        String string = "";
        if (c == 'T') {
            string = "hasType = " + this.QUOTE_CHAR + "T" + this.QUOTE_CHAR;
        } else {
            String string2 = bl ? " = ?" : " is not null";
            String string3 = null;
            if (c == 'S') {
                string3 = "subj";
            } else if (c == 'P') {
                string3 = "prop";
            } else if (c == 'O') {
                string3 = "obj";
            } else {
                throw new JenaException("Undefined reification property");
            }
            string = string3 + string2;
        }
        return string;
    }

    protected int getTableCount(int n) {
        try {
            DatabaseMetaData databaseMetaData = this.m_dbcon.getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            int n2 = 0;
            String string = "jena_g" + Integer.toString(n) + "%";
            string = this.stringToDBname(string);
            ResultSet resultSet = databaseMetaData.getTables(null, null, string, stringArray);
            while (resultSet.next()) {
                ++n2;
            }
            resultSet.close();
            return n2;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", sQLException);
        }
    }

    public boolean doesTableExist(String string) {
        ArrayList<String> arrayList;
        boolean bl = false;
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            String string2 = this.stringToDBname("jena%");
            ResultSet resultSet = databaseMetaData.getTables(null, null, string2, stringArray);
            arrayList = new ArrayList<String>(10);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal SQL error in driver", sQLException);
        }
        return bl &= arrayList.contains(this.stringToDBname(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RDBLongObject {
        String head;
        long hash;
        String tail;

        RDBLongObject() {
        }
    }

    class ParseInt {
        int pos;
        Integer val;

        ParseInt(int n) {
            this.pos = n;
        }
    }
}

