/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.DB;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DBPropDatabase
extends DBProp {
    public static final Node_URI dbEngineType = (Node_URI)DB.engineType.getNode();
    public static final Node_URI dbLayoutVersion = (Node_URI)DB.layoutVersion.getNode();
    public static final Node_URI dbDriverVersion = (Node_URI)DB.driverVersion.getNode();
    public static final Node_URI dbFormatDate = (Node_URI)DB.formatDate.getNode();
    public static final Node_URI dbGraph = (Node_URI)DB.graph.getNode();
    public static final Node_URI dbMaxLiteral = (Node_URI)DB.maxLiteral.getNode();
    public static final String dbSystemGraphName = "SystemGraph";
    protected static SimpleDateFormat dateFormat = null;
    static final Map1 graphToName = new Map1(){

        public Object map1(Object object) {
            return ((DBPropGraph)object).getName();
        }
    };

    public DBPropDatabase(SpecializedGraph specializedGraph, String string, String string2, String string3) {
        super(specializedGraph);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        String string4 = dateFormat.format(new Date());
        if (string != null) {
            this.putPropString(dbEngineType, string);
        }
        if (string2 != null) {
            this.putPropString(dbDriverVersion, string2);
        }
        this.putPropString(dbLayoutVersion, "2.0");
        if (string3 != null) {
            this.putPropString(dbMaxLiteral, string3);
        }
        this.putPropString(dbFormatDate, string4);
    }

    public DBPropDatabase(SpecializedGraph specializedGraph, Node node) {
        super(specializedGraph, node);
    }

    public DBPropDatabase(SpecializedGraph specializedGraph) {
        super(specializedGraph, DBPropDatabase.findDBPropNode(specializedGraph));
    }

    public String getName() {
        return this.self.getURI();
    }

    public String getEngineType() {
        return this.getPropString(dbEngineType);
    }

    public String getDriverVersion() {
        return this.getPropString(dbDriverVersion);
    }

    public String getFormatDate() {
        return this.getPropString(dbFormatDate);
    }

    public void addGraph(DBPropGraph dBPropGraph) {
        this.putPropNode(dbGraph, dBPropGraph.getNode());
    }

    public void removeGraph(DBPropGraph dBPropGraph) {
        SpecializedGraph.CompletionFlag completionFlag = DBPropDatabase.newComplete();
        ExtendedIterator extendedIterator = this.graph.find(this.self, dbGraph, dBPropGraph.getNode(), completionFlag);
        if (extendedIterator.hasNext()) {
            this.graph.delete((Triple)extendedIterator.next(), completionFlag);
            dBPropGraph.remove();
        }
    }

    public ExtendedIterator getAllGraphs() {
        return this.graph.find(this.self, dbGraph, null, DBPropDatabase.newComplete()).mapWith(new MapToLSet());
    }

    public ExtendedIterator getAllGraphNames() {
        return this.getAllGraphs().mapWith(graphToName);
    }

    static Node findDBPropNode(SpecializedGraph specializedGraph) {
        ExtendedIterator extendedIterator = specializedGraph.find(null, dbEngineType, null, DBPropDatabase.newComplete());
        if (extendedIterator.hasNext()) {
            return ((Triple)extendedIterator.next()).getSubject();
        }
        return null;
    }

    private class MapToLSet
    implements Map1 {
        private MapToLSet() {
        }

        public Object map1(Object object) {
            Triple triple = (Triple)object;
            return new DBPropGraph(DBPropDatabase.this.graph, triple.getObject());
        }
    }
}

