

import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;

import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.message.MessageElement;
import org.w3.www._2001.sw.DataAccess.sparql_11_example.SPARQLQueryServiceLocator;
import org.w3.www._2005._08.sparql_protocol_query.SparqlQueryInterface;
import org.w3.www._2005._09.sparql_protocol_types.MalformedQuery;
import org.w3.www._2005._09.sparql_protocol_types.QueryRequest;
import org.w3.www._2005._09.sparql_protocol_types.QueryRequestRefused;
import org.w3.www._2005._09.sparql_protocol_types.QueryResult;
import org.w3.www._2005.sparql_results.Results;
import org.w3.www._2005.sparql_results.Sparql;
import org.xml.sax.SAXException;


public class RunClient
{
	// "Deserialize" RDF/XML into a string 
	static public class SimpleDeserializer extends DeserializerImpl implements Deserializer
	{
	    public SimpleDeserializer() {}
	    
	    public void startElement(String namespace,
	                             String localName,
	                             String prefix,
	                             org.xml.sax.Attributes attributes,
	                             DeserializationContext context)
	    throws SAXException
	    {
	        try {
	            MessageElement elt = context.getCurElement(); // the RDF doc element 
	            String s = elt.getAsString(); // This serializes the message element
	            super.setValue(s);
	        } catch (Exception ex)
	        {
	            ex.printStackTrace();
	        }
	    }
	}
	static public class SimpleDeserializerFactory implements DeserializerFactory
	{
	    public Deserializer getDeserializerAs(String arg0)
	    {
	        return new SimpleDeserializer() ;
	    }

	    public Iterator getSupportedMechanismTypes()
	    {
	        Vector v = new Vector() ;
	        v.add(Constants.AXIS_SAX);
	        return v.iterator();
	    }

	}

	// TODO - Set this to the URL of the endpoint against which you are querying 
    static String endpoint = "http://localhost:2525/axis/services/sparql-query" ;
    public static void main(String[] args)
    {
    	// Example queries.
        doOneSelectQuery(); 
        doOneConstructQuery(); 
    }
    
    
    public static void runQuery(String query, String endpoint) {
        // Setup our service to point to our endpoint
    	SPARQLQueryServiceLocator  service = new SPARQLQueryServiceLocator();
        service.setSparqlQueryEndpointAddress(endpoint) ;
     
        // Retrieve a reference to the SparqlQuery interface
        SparqlQueryInterface soapQuery = null;
        try {
            soapQuery = service.getSparqlQuery() ;
        } catch (javax.xml.rpc.ServiceException ex) { 
        	throw new RuntimeException("Query exception: " + ex.getMessage()) ; 
        }
        
    	// We register a stub class to deserialize RDF/XML
    	// so that Axis does not complain. A "real" implementation
    	// would use a deserialization class that parses the RDF/XML
    	// into an appropriate graph representation. Our deserializer
        // simply returns a string representation of the RDF/XML returned.
        TypeMappingRegistry reg = service.getEngine().getTypeMappingRegistry() ;
        TypeMapping tm = (TypeMapping)reg.getTypeMapping("") ;
        tm.register(
        	String.class, // the type to deserialize to
            new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF") ,
            null, 							// SerializerFactory
            new SimpleDeserializerFactory()
        );
        
        
        QueryRequest q = new QueryRequest() ;
        q.setQuery(query) ;
        // Any default graphs or named graphs would be set here
        //q.setDefaultGraphUri(new URI[] { ... });
        //q.setNamedGraphUri(new URI[] { ... });
        
        QueryResult result = null;
        try {
            result =  soapQuery.query(q) ;
        } catch (MalformedQuery ex) {
            throw new RuntimeException("Malformed query fault: " + ex.getFaultString(), ex) ;
        } catch (QueryRequestRefused refused) {
        	throw new RuntimeException("Query request refused fault: " + refused.getFaultString(), refused);
        } catch (AxisFault axisFault) {
            throw new RuntimeException("Axis Fault: "+axisFault.getFaultString(), axisFault); 
        } catch (RemoteException e) {
            throw new RuntimeException("Remote Exception: "+e.getMessage(), e) ; 
        }

        // Switch on the type of the result received and act accordingly.
        if (result.getRDF() != null) {
        	System.out.println("RDF/XML returned:");
        	// In this example, the result of deserializing RDF/XML is simply a string  
        	System.out.println(result.getRDF());
        } else if (result.getSparql() != null) {
        	System.out.println("VBR returned.");
        	// Beans are generated for the SPARQL Query Results XML Format schema,
        	// so we can use them to walk through our resultset.
        	Sparql sparql = result.getSparql();
        	if (sparql.get_boolean() == null) {
        		Results results = sparql.getResults();
        		System.out.println("SELECT returned " + results.getResult().length + " rows");
        	} else {
        		System.out.println("ASK result is: " + sparql.get_boolean());
        	}
        } else {
        	System.out.println("Something else ?? returned.");
        }
    }
    
    public static void doOneSelectQuery()
    {
    	// Sample query.
        String queryStr = "\nSELECT ?z {?x ?y ?z . FILTER regex(?z, 'Harry')}\n" ;
        runQuery(queryStr, endpoint);
    }

    public static void doOneConstructQuery()
    {
    	// Sample query.
        String queryStr = 
            "PREFIX dc:      <http://purl.org/dc/elements/1.1/>\n" + 
            "CONSTRUCT { $book dc:title $title } WHERE { $book dc:title $title }";
            
        runQuery(queryStr, endpoint);        
    }

}

/*
 * (c) Copyright 2004, 2005 Hewlett-Packard Development Company, LP
 * (c) Copyright 2005 International Business Machines Corporation
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
