//
// $Id$
// From Philippe Le Hegaret (Philippe.Le_Hegaret@sophia.inria.fr)
//
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html
/*
 * $Log$
 */

package org.w3c.css.util;

import java.util.Properties;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.net.URL;

/**
 * @version $Revision$
 */
public class Messages {
    
    /**
     * Message properties
     */  
    public Properties properties;

    private static Hashtable languages = new Hashtable();
    
    /**
     * Creates a new Messages
     */
    public Messages(String lang) {
	if (lang != null) {
	    StringTokenizer lanTok = new StringTokenizer(lang, ",");
	    
	    while (lanTok.hasMoreTokens()) {
		String l = lanTok.nextToken().trim().toLowerCase();
		properties = (Properties) languages.get(l);
		if (properties != null) {
		    break;
		}
		int minusIndex = l.indexOf('-');
		if (minusIndex != -1) {
		    // suppressed -cn in zh-cn (example)
		    l = l.substring(0, minusIndex);
		    properties = (Properties) languages.get(l);
		}
		if (properties != null) {
		    break;
		}		
	    }
	}
	if (properties == null) {
	    properties = (Properties) languages.get("en");
	}
    }
    
    
    /**
     * Get a property.
     */  
    public String getString(String message) {
	return properties.getProperty(message);
    }
    
    /**
     * Get a warning property.
     * 
     * @param message the warning property.
     */  
    public String getWarningString(String message) {
	return getString(new StringBuffer("warning.").append(message).toString());
    }
    
    /**
     * Get a warning level property.
     * 
     * @param message the warning property.
     */  
    public String getWarningLevelString(String message) {
	return getString(new StringBuffer("warning.").append(message).append(".level").toString());
    }
    
    /**
     * Get an error property.
     *
     * @param message the error property.
     */  
    public String getErrorString(String message) {
	return getString(new StringBuffer("error.").append(message).toString());
    }
    
    /**
     * Get an generator property.
     *
     * @param message the generator property.
     */  
    public String getGeneratorString(String message) {
	return getString(new StringBuffer("generator.").append(message).toString());
    }
    
    /**
     * Get an generator property.
     *
     * @param message the generator property.
     */  
    public String getGeneratorString(String message, String param) {
	String str = getString(new StringBuffer("generator.").append(message).toString());
	
	// replace all parameters
	int i = str.indexOf("%s");
	if (i >= 0) {
	    str = str.substring(0, i) + param + str.substring(i+2);
	}
	return str;
    }
    
    /**
     * Get an generator property.
     *
     * @param message the generator property.
     */  
    public String getServletString(String message) {
	return getString(new StringBuffer("servlet.").append(message).toString());
    }
    
    static {
	Properties tmp;
	try {
	    URL url = Messages.class.getResource("Messages.properties.en");
	    java.io.InputStream f = url.openStream();
	    try {
		tmp = new Properties();
		tmp.load(f);
		languages.put("en", tmp);
	    } finally {
		f.close();
	    }
	} catch (Exception e) {
	    System.err.println("org.w3c.css.util.Messages: couldn't load properties en");
	    System.err.println("  " + e.toString() );
	}

	try {
	    URL url = Messages.class.getResource("Messages.properties.zh-cn");
	    java.io.InputStream f = url.openStream();
	    try {
		tmp = new Properties();
		tmp.load(f);
		languages.put("zh-cn", tmp);
	    } finally {
		f.close();
	    }
	} catch (Exception e) {
	    System.err.println("org.w3c.css.util.Messages: couldn't load properties cn");
	    System.err.println("  " + e.toString() );
	}

	try {
	    URL url = Messages.class.getResource("Messages.properties.ja");
	    java.io.InputStream f = url.openStream();
	    try {
		tmp = new Properties();
		tmp.load(f);
		languages.put("ja", tmp);
	    } finally {
		f.close();
	    }
	} catch (Exception e) {
	    System.err.println("org.w3c.css.util.Messages: couldn't load properties ja");
	    System.err.println("  " + e.toString() );
	}

        try {
            URL url = Messages.class.getResource("Messages.properties.fr");
            java.io.InputStream f = url.openStream();
            try {
                tmp = new Properties();
                tmp.load(f);
                languages.put("fr", tmp);
		languages.put("fr_FR", tmp);
            } finally {
                f.close();
            }
        } catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties fr");
            System.err.println("  " + e.toString() );
        }

	//-----------------------

        try {
            URL url = Messages.class.getResource("Messages.properties.de");
            java.io.InputStream f = url.openStream();
            try {
                tmp = new Properties();
                tmp.load(f);
                languages.put("de", tmp);
                languages.put("de_DE", tmp);
                languages.put("de_AT", tmp);
                languages.put("de_CH", tmp);
            } finally {
                f.close();
            }
	} catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties de");
            System.err.println("  " + e.toString() );
        }

	// ------------------------------------------------

	try {
	    URL url = Messages.class.getResource("Messages.properties.nl");
	    java.io.InputStream f = url.openStream();
	    try {
		tmp = new Properties();
		tmp.load(f);
		languages.put("nl", tmp);
	    } finally {
		f.close();
	    }
	} catch (Exception e) {
	    System.err.println("org.w3c.css.util.Messages: couldn't load properties nl");
	    System.err.println("  " + e.toString() );
	}


    }
}
