//
// $Id$
// From Sijtsche de Jong (sy.de.jong@let.rug.nl)
//
// COPYRIGHT (c) 1995-2000 World Wide Web Consortium, (MIT, INRIA, Keio University)
// Please first read the full copyright statement at
// http://www.w3.org/Consortium/Legal/copyright-software-19980720

package org.w3c.css.svgproperties;

import org.w3c.css.util.Warnings;
import org.w3c.css.util.Warning;
import org.w3c.css.util.ApplContext;
import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.values.CssValue;

public class SVGStyle extends org.w3c.css.properties3.Css3Style {

    AlignmentBaseline alignmentBaseline;
    ClipPath clipPath;
    ClipRule clipRule;
    ColorInterpolation colorInterpolation;
    ColorRendering colorRendering;
    EnableBackground enableBackground;
    WritingModeSVG writingModeSVG;
    FloodOpacity floodOpacity;
    Filter filter;
    FillRule fillRule;
    FillOpacity fillOpacity;
    ImageRendering imageRendering;
    Mask mask;
    StopOpacity stopOpacity;
    Kerning kerning;
    Marker marker;
    MarkerStart markerStart;
    MarkerEnd markerEnd;
    MarkerMid markerMid; 
    PointerEvents pointerEvents;
    ShapeRendering shapeRendering;
    TextRendering textRendering;
    TextAnchor textAnchor;
    StrokeLinejoin strokeLinejoin;
    StrokeLineCap strokeLineCap;
    StrokeMiterLimit strokeMiterLimit;
    StrokeOpacity strokeOpacity;
    StrokeWidth strokeWidth;
    StrokeDashOffset strokeDashOffset;
    StrokeDashArray strokeDashArray;
    StopColor stopColor;
    LightingColor lightingColor;
    FloodColor floodColor;
    Stroke stroke;
    ColorProfile colorProfile;

    public AlignmentBaseline getAlignmentBaseline() {
	if (alignmentBaseline == null) {
	    alignmentBaseline =
		(AlignmentBaseline) style.CascadingOrder (
			    new AlignmentBaseline(), style, selector);
	}
	return alignmentBaseline;
    }

    public ClipPath getClipPath() {
	if (clipPath == null) {
	    clipPath =
		(ClipPath) style.CascadingOrder (
			    new ClipPath(), style, selector);
	}
	return clipPath;
    }

    public ClipRule getClipRule() {
	if (clipRule == null) {
	    clipRule =
		(ClipRule) style.CascadingOrder (
			    new ClipRule(), style, selector);
	}
	return clipRule;
    }

    public ColorInterpolation getColorInterpolation() {
	if (colorInterpolation == null) {
	    colorInterpolation =
		(ColorInterpolation) style.CascadingOrder (
			    new ColorInterpolation(), style, selector);
	}
	return colorInterpolation;
    }

    public ColorRendering getColorRendering() {
	if (colorRendering == null) {
	    colorRendering =
		(ColorRendering) style.CascadingOrder (
			    new ColorRendering(), style, selector);
	}
	return colorRendering;
    }

    public EnableBackground getEnableBackground() {
	if (enableBackground == null) {
	    enableBackground =
		(EnableBackground) style.CascadingOrder (
			    new EnableBackground(), style, selector);
	}
	return enableBackground;
    }

    public WritingModeSVG getWritingModeSVG() {
	if (writingModeSVG == null) {
	    writingModeSVG =
		(WritingModeSVG) style.CascadingOrder (
			   new WritingModeSVG(), style, selector);
	}
	return writingModeSVG;
    }

    public FloodOpacity getFloodOpacity() {
	if (floodOpacity == null) {
	    floodOpacity =
		(FloodOpacity) style.CascadingOrder (
			   new FloodOpacity(), style, selector);
	}
	return floodOpacity;
    }

    public Filter getFilter() {
	if (filter == null) {
	    filter =
		(Filter) style.CascadingOrder (
			   new Filter(), style, selector);
	}
	return filter;
    }

    public FillRule getFillRule() {
	if (fillRule == null) {
	    fillRule =
		(FillRule) style.CascadingOrder (
			   new FillRule(), style, selector);
	}
	return fillRule;
    }

    public FillOpacity getFillOpacity() {
	if (fillOpacity == null) {
	    fillOpacity =
		(FillOpacity) style.CascadingOrder (
			   new FillOpacity(), style, selector);
	}
	return fillOpacity;
    }

    public ImageRendering getImageRendering() {
	if (imageRendering == null) {
	    imageRendering =
		(ImageRendering) style.CascadingOrder (
			   new ImageRendering(), style, selector);
	}
	return imageRendering;
    }

    public Mask getMask() {
	if (mask == null) {
	    mask =
		(Mask) style.CascadingOrder (
			   new ImageRendering(), style, selector);
	}
	return mask;
    }

    public StopOpacity getStopOpacity() {
	if (stopOpacity == null) {
	    stopOpacity =
		(StopOpacity) style.CascadingOrder (
			   new StopOpacity(), style, selector);
	} 
	return stopOpacity;
    }

    public Kerning getKerning() {
	if (kerning == null) {
	    kerning =
		(Kerning) style.CascadingOrder (
			   new Kerning(), style, selector);
	} 
	return kerning;
    }

    public Marker getMarker() {
	if (marker == null) {
	    marker =
		(Marker) style.CascadingOrder (
			   new Marker(), style, selector);
	} 
	return marker;
    }

    public MarkerStart getMarkerStart() {
	if (markerStart == null) {
	    markerStart =
		(MarkerStart) style.CascadingOrder (
			   new MarkerStart(), style, selector);
	} 
	return markerStart;
    }

    public MarkerEnd getMarkerEnd() {
	if (markerEnd == null) {
	    markerEnd =
		(MarkerEnd) style.CascadingOrder (
			   new MarkerEnd(), style, selector);
	} 
	return markerEnd;
    }

    public MarkerMid getMarkerMid() {
	if (markerMid == null) {
	    markerMid =
		(MarkerMid) style.CascadingOrder (
			   new MarkerMid(), style, selector);
	} 
	return markerMid;
    }

    public PointerEvents getPointerEvents() {
	if (pointerEvents == null) {
	    pointerEvents =
		(PointerEvents) style.CascadingOrder (
			    new PointerEvents(), style, selector);
	}
	return pointerEvents;
    }

    public ShapeRendering getShapeRendering() {
	if (shapeRendering == null) {
	    shapeRendering =
		(ShapeRendering) style.CascadingOrder (
			    new ShapeRendering(), style, selector);
	}
	return shapeRendering;
    }

    public TextRendering getTextRendering() {
	if (textRendering == null) {
	    textRendering =
		(TextRendering) style.CascadingOrder (
			    new TextRendering(), style, selector);
	}
	return textRendering;
    }

    public TextAnchor getTextAnchor() {
	if (textAnchor == null) {
	    textAnchor =
		(TextAnchor) style.CascadingOrder (
			     new TextAnchor(), style, selector);
	}
	return textAnchor;
    }

    public StrokeLinejoin getStrokeLinejoin() {
	if (strokeLinejoin == null) {
	    strokeLinejoin =
		(StrokeLinejoin) style.CascadingOrder (
			     new StrokeLinejoin(), style, selector);
	}
	return strokeLinejoin;
    }

    public StrokeLineCap getStrokeLineCap() {
	if (strokeLineCap == null) {
	    strokeLineCap =
		(StrokeLineCap) style.CascadingOrder (
			     new StrokeLineCap(), style, selector);
	}
	return strokeLineCap;
    }

    public StrokeMiterLimit getStrokeMiterLimit() {
	if (strokeMiterLimit == null) {
	    strokeMiterLimit =
		(StrokeMiterLimit) style.CascadingOrder (
			     new StrokeMiterLimit(), style, selector);
	}
	return strokeMiterLimit;
    }

    public StrokeOpacity getStrokeOpacity() {
	if (strokeOpacity == null) {
	    strokeOpacity =
		(StrokeOpacity) style.CascadingOrder (
			      new StrokeOpacity(), style, selector);
	}
	return strokeOpacity;
    }

    public StrokeWidth getStrokeWidth() {
	if (strokeWidth == null) {
	    strokeWidth =
		(StrokeWidth) style.CascadingOrder (
			      new StrokeWidth(), style, selector);
	}
	return strokeWidth;
    }

    public StrokeDashOffset getStrokeDashOffset() {
	if (strokeDashOffset == null) {
	    strokeDashOffset =
		(StrokeDashOffset) style.CascadingOrder (
			      new StrokeDashOffset(), style, selector);
	}
	return strokeDashOffset;
    }

    public StrokeDashArray getStrokeDashArray() {
	if (strokeDashArray == null) {
	    strokeDashArray =
		(StrokeDashArray) style.CascadingOrder (
			      new StrokeDashArray(), style, selector);
	}
	return strokeDashArray;
    }

    public StopColor getStopColor() {
	if (stopColor == null) {
	    stopColor =
		(StopColor) style.CascadingOrder (
			       new StopColor(), style, selector);
	}
	return stopColor;
    }

    public LightingColor getLightingColor() {
	if (lightingColor == null) {
	    lightingColor =
		(LightingColor) style.CascadingOrder(
			       new LightingColor(), style, selector);
	}
	return lightingColor;
    }

    public FloodColor getFloodColor() {
	if (floodColor == null) {
	    floodColor =
		(FloodColor) style.CascadingOrder (
			       new FloodColor(), style, selector);
	}
	return floodColor;
    }

    public ColorProfile getColorProfileSVG() {
	if (colorProfile == null) {
	    colorProfile =
		(ColorProfile) style.CascadingOrder (
			       new ColorProfile(), style, selector);
	}
	return colorProfile;
    }
    
    public Stroke getStroke() {
	if (stroke == null) {
	    stroke =
		(Stroke) style.CascadingOrder (
			       new Stroke(), style, selector);
	}
	return stroke;
    }

    /**
     * Print this style
     *
     * @param printer The printer interface
     */
    public void print(CssPrinterStyle printer) {
	super.print(printer);

	if (alignmentBaseline != null) {
	    alignmentBaseline.print(printer);
	}
	if (clipPath != null) {
	    clipPath.print(printer);
	}
	if (clipRule != null) {
	    clipRule.print(printer);
	}
	if (colorInterpolation != null) {
	    colorInterpolation.print(printer);
	}
	if (colorRendering != null) {
	    colorRendering.print(printer);
	}
	if (enableBackground != null) {
	    enableBackground.print(printer);
	}
	if (writingModeSVG != null) {
	    writingModeSVG.print(printer);
	}
	if (floodOpacity != null) {
	    floodOpacity.print(printer);
	}
	if (filter != null) {
	    filter.print(printer);
	}
	if (fillRule != null) {
	    fillRule.print(printer);
	}
	if (fillOpacity != null) {
	    fillOpacity.print(printer);
	}
	if (imageRendering != null) {
	    imageRendering.print(printer);
	}
	if (mask != null) {
	    mask.print(printer);
	}
	if (stopOpacity != null) {
	    stopOpacity.print(printer);
	}
	if (kerning != null) {
	    kerning.print(printer);
	}
	if (marker != null) {
	    marker.print(printer);
	}
	if (markerStart != null) {
	    markerStart.print(printer);
	}
	if (markerEnd != null) {
	    markerEnd.print(printer);
	}
	if (markerMid != null) {
	    markerMid.print(printer);
	}
	if (pointerEvents != null) {
	    pointerEvents.print(printer);
	}
	if (shapeRendering != null) {
	    shapeRendering.print(printer);
	}
	if (textRendering != null) {
	    textRendering.print(printer);
	}
	if (textAnchor != null) {
	    textAnchor.print(printer);
	}
	if (strokeLinejoin != null) {
	    strokeLinejoin.print(printer);
	}
	if (strokeLineCap != null) {
	    strokeLineCap.print(printer);
	}
	if (strokeMiterLimit != null) {
	    strokeMiterLimit.print(printer);
	}
	if (strokeOpacity != null) {
	    strokeOpacity.print(printer);
	}
	if (strokeWidth != null) {
	    strokeWidth.print(printer);
	}
	if (strokeDashOffset != null) {
	    strokeDashOffset.print(printer);
	}
	if (strokeDashArray != null) {
	    strokeDashArray.print(printer);
	}
	if (stopColor != null) {
	    stopColor.print(printer);
	}
	if (lightingColor != null) {
	    lightingColor.print(printer);
	}
	if (floodColor != null) {
	    floodColor.print(printer);
	}
	if (stroke != null) {
	    stroke.print(printer);
	}
	if (colorProfile != null) {
	    colorProfile.print(printer);
	}
    }

    /**
     * Returns the name of the actual selector
     */
    public String getSelector()
    {
	return (selector.getElement().toLowerCase());
    }
    
}
