//
// $Id$
// From Philippe Le Hegaret (Philippe.Le_Hegaret@sophia.inria.fr)
//
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html
/*
 * $Log$
 */
package org.w3c.css.parser;

import java.io.IOException;
import java.net.URL;
import w3c.xmlOnline.parser.XMLTokenizer;
import w3c.xmlOnline.parser.Parser;

/**
 * @version $Revision$
 */
public class CssXMLParser extends Parser {

  URL sourceFile;
  
  /**
   * Create a new CssXMLParser.
   *
   * @param name name of the file that is being parsed
   * @param scanner the tokenizer used to read the file
   * @return the new MyParser
   */
  public CssXMLParser(URL name, XMLTokenizer scanner, CssValidatorListener valide) {
    super(scanner);
    addListener(new CssXMLListener(name, valide));
    sourceFile = name;
  }

  /**
   * Get the source file
   */
  public final String getSourceFile() {
    return sourceFile.toString();
  }

  /**
   * Get the URL.
   */
  public final URL getURL() {
    return sourceFile;
  }

  /**
   * Get the current line. It doesn't work. I do this function for a futur
   * usage.
   */
  public final int getLine() {
    return 0;
  }

  /**
   * Print an error message for an unexpected token. This is called
   * by the parser during error recovery.
   */
  public void deletion(int token) {
    // nothing to do for the moment
  }

  /**
   * Print an error message for a missing token. This is called
   * by the parser during error recovery.
   */
  public void insertion(int token) {
    // nothing to do for the moment
  }

  /**
   * Parse ths style sheet.
   */  
  public void parseStyle() throws IOException {
    parse();
  }
}
